package w83b.w83bDAO;

import java.sql.CallableStatement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.Thread.W83bNotificacionThread;
import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bLotesPreavisosBean;
import w83b.w83bBeans.W83bNotificacionesBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bLotesPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bUsuariosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bInformacionProcedimiento;
import w83b.w83bUtilidadesComunes.W83bProperties;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

public class W83bBandejaEntradaDAO implements W83bIBandejaEntradaDAO {
	
	public java.util.List busquedaBandejaEntrada(w83b.w83bBeans.W83bPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.preaviso_008).append(", ");
		strSql.append(W83bPreavisosBD.f_entrada_007).append(", ");
		strSql.append(W83bPreavisosBD.f_inicio_008).append(", ");
		strSql.append("upper(");
		strSql.append(W83bPreavisosBD.raz_social_008).append(") AS ");
		strSql.append(W83bPreavisosBD.raz_social_008).append(", ");
		strSql.append(W83bPreavisosBD.cif_008).append(", ");
		strSql.append(W83bPreavisosBD.prov_008).append(", ");
		strSql.append(W83bPreavisosBD.munic_008).append(", ");
		strSql.append(W83bPreavisosBD.estado_008).append(", ");
		strSql.append("upper(");
		strSql.append(W83bPreavisosBD.descprovincia).append(") AS ");
		strSql.append(W83bPreavisosBD.descprovincia).append(", ");
		strSql.append("upper(");
		strSql.append(W83bPreavisosBD.descmunicipio).append(") AS ");
		strSql.append(W83bPreavisosBD.descmunicipio).append(", ");
		strSql.append("'").append(param.getIdioma()).append("' as IDIOMA");
		strSql.append(" FROM ").append(W83bPreavisosBD.w83bbusqbandejaentrada);	
		strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_008).append("=?");	
			
		
		params.add(param.getCodTerritorio());
		
		if (StringUtils.isNotEmpty(param.getEstado())){
			strSql.append(" AND ").append(W83bPreavisosBD.estado_008).append("=?");
			if (W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(param.getEstado())){
				params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
			}else{
				params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
			}
		}
		
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,param.getUsuarioBean(), "PREAVPENDIENTESTRAMITAR");		
		return listaPreavisos;//NOPMD
	}
	
	public w83b.w83bBeans.W83bPreavisosBean buscarDetallePreaviso(java.util.HashMap param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.raz_social_008).append(", ");
		strSql.append(W83bPreavisosBD.domic_008).append(", ");
		strSql.append(W83bPreavisosBD.c_territ_008).append(", ");
		strSql.append(W83bPreavisosBD.munic_008).append(", ");
		strSql.append(W83bPreavisosBD.codpos_008).append(", ");
		strSql.append(W83bPreavisosBD.telefono_008).append(", ");
		strSql.append(W83bPreavisosBD.fax_008).append(", ");
		strSql.append(W83bPreavisosBD.email_008).append(", ");
		strSql.append(W83bPreavisosBD.cnae_008).append(", ");
		strSql.append(W83bPreavisosBD.f_inicio_008).append(", ");
		strSql.append(W83bPreavisosBD.c_conv_008).append(", ");
		strSql.append(W83bPreavisosBD.s_parcial_008).append(", ");
		strSql.append(W83bPreavisosBD.global_008).append(", ");
		strSql.append(W83bPreavisosBD.admonemp_008).append(", ");
		strSql.append(W83bPreavisosBD.n_cenafec_008).append(", ");
		strSql.append(W83bPreavisosBD.c_sindi_prom_008).append(", ");
		strSql.append(W83bPreavisosBD.c_sindi_prom_multi_008).append(", ");
		strSql.append(W83bPreavisosBD.ident_008).append(", ");
		strSql.append(W83bPreavisosBD.observ_008).append(", ");
		strSql.append(W83bPreavisosBD.estado_008).append(", ");
		strSql.append(W83bPreavisosBD.preaviso_008).append(", ");
		strSql.append(W83bPreavisosBD.f_entrada_007).append(", ");
		strSql.append(W83bPreavisosBD.desccnae).append(", ");
		strSql.append(W83bPreavisosBD.cif_008).append(", ");
		strSql.append(W83bPreavisosBD.lote_008).append(", ");
		strSql.append(W83bPreavisosBD.n_regis_008).append(", ");
		strSql.append(W83bPreavisosBD.prov_008).append(", ");
		strSql.append(W83bPreavisosBD.n_preavisos_007).append(", ");
		strSql.append(W83bPreavisosBD.c_sindi_007).append(", ");
		strSql.append(W83bPreavisosBD.correl_007).append(", ");
		strSql.append(W83bPreavisosBD.nombreficheroida).append(", ");
		strSql.append(W83bPreavisosBD.f_creacion_007).append(", ");
		strSql.append(W83bPreavisosBD.identfiscal).append(", ");
		strSql.append(W83bPreavisosBD.territsegsocial).append(", ");
		strSql.append(W83bPreavisosBD.numsegsocial).append(", ");
		strSql.append(W83bPreavisosBD.digcontsegsocial).append(", ");
		strSql.append(W83bPreavisosBD.numcentro008).append(", ");
		strSql.append(W83bPreavisosBD.numtrab).append(", ");
		strSql.append("'").append(param.get("idioma")).append("' as IDIOMA").append(", ");
		strSql.append(W83bPreavisosBD.f_regis_008).append(",");
		strSql.append(W83bPreavisosBD.descConvenioCas).append(",");
		strSql.append(W83bPreavisosBD.descConvenioEus);
		//strSql.append(",").append(W83bPreavisosBD.descSindi);
		strSql.append(", prov.ds_o as descprovincia, mun.ds_o as descmunicipio");
		 
		
		
		strSql.append(" FROM ").append(W83bPreavisosBD.w83bdetallepreavpendtram);	
		strSql.append(" , ").append(W83bPreavisosBD.tablaConvenios);	
		//strSql.append(" , ").append(W83bPreavisosBD.tablaSindicatos);	
		strSql.append(" , T17I.T17_PROVINCIA prov,T17I.T17_MUNICIPIO mun ");
		strSql.append(" WHERE ").append(W83bPreavisosBD.preaviso_008).append("=?");	
		strSql.append(" AND ").append(W83bPreavisosBD.c_conv_008).append("=").append(W83bPreavisosBD.c_conv_013).append("(+)"); 
		//strSql.append(" AND ").append(W83bPreavisosBD.c_sindi_prom_008).append("=").append(W83bPreavisosBD.c_sindi_019).append("(+)");
		strSql.append(" AND c_territ_008=prov.id AND munic_008=mun.id(+) AND c_territ_008=provincia_id(+) ");
		
		params.add(param.get("codpreaviso"));
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,(W83bUsuarioXLNetsBean)param.get("user"), "DETALLEPREAVPENDTRAM");		
		return (W83bPreavisosBean)listaPreavisos.get(0);
	}
	
	public java.lang.String modificarEstadoPreaviso(w83b.w83bBeans.W83bPreavisosBean param, String estado) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		try{
			strSql.append("UPDATE ");
			strSql.append(W83bPreavisosBD.preavPendientesTramTabla);
			strSql.append(" SET ");
			strSql.append(W83bPreavisosBD.estado_008).append(" = ? ");
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.preaviso_008).append(" = ? ");
			
		    params.add(estado);
			params.add(param.getCodpreaviso());
			
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
			
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "modificarEstadoPreaviso", null);
			throw e;
		}
		
		return "0";
	}
	
	public String anyadirPreavisos(W83bPreavisosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		try{
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preavisosTable);
			
			strSql.append("(");
			strSql.append(W83bPreavisosBD.ano_preaviso_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_preaviso_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.id_centro_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_entra_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_inicio_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_elecc_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_regis_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_regis_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_acta_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_acta_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.s_parcial_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.global_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.observ_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usua_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.factu_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.convacu_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.admonemp_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_cenafec_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.fenvio_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usuenv_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ncarprocelec_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.oid8501_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.nop_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ndf_037);
			strSql.append(",");
		
			strSql.append(W83bPreavisosBD.c_conv_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.dir_alt_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.codPos_alt_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.mun_alt_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.prov_alt_037);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.tipoPreav);
			strSql.append(")");
			
			strSql.append(" VALUES (?,?,?,to_date(?,?),to_date(?,?),");
			if(StringUtils.isNotEmpty(param.getFecha_eleccion())){
				strSql.append("to_date(?,?)");
			}else{
				strSql.append("?");			
			}
			
			if(StringUtils.isNotEmpty(param.getFechaRegES())){
				strSql.append(",to_date(?,?),?,");
			}else{
				strSql.append(",?,?,");
			}
				
			strSql.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			
			params.add(new Integer(param.getAnyoPreaviso()));
			
			
			//NO COMENTAR ESTA LINEA AUNQUE DE ERROR EN EL PMD Y CHECKSTYLE!!!!!
			HashMap mapa = W83bFactoriaDAO.getPreavisosDAO().calcularNumPreaviso(param);
			//NO COMENTAR LINEA ANTERIOR AUNQUE DE ERROR EN EL PMD Y CHECKSTYLE!!!!!

			params.add(new Integer(param.getNum_preaviso()));
			//TODO obtener el id del centro
			params.add(new Integer(param.getIdCentroTrabajo()));
			params.add(param.getFecha_entrada());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(param.getFecha_inicio());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			if(StringUtils.isNotEmpty(param.getFecha_eleccion())){
				params.add(param.getFecha_eleccion());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			//Fecha de registro
			
			if(StringUtils.isNotEmpty(param.getFechaRegES())){
				params.add(param.getFechaRegES());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			if(StringUtils.isNotEmpty(param.getNumRegES())){
				//Numero de registro
				params.add(param.getNumRegES());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}

			if(StringUtils.isNotEmpty(param.getAnyo_acta())){
				params.add(param.getAnyo_acta());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if(StringUtils.isNotEmpty(param.getNum_acta())){
				params.add(param.getNum_acta());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getS_parcial_008())){
				params.add(param.getS_parcial_008().toUpperCase());
			}else{
				params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getGlobal_008())){
				params.add(param.getGlobal_008().toUpperCase());
			}else{
				params.add("N");
			}
			if(StringUtils.isNotEmpty(param.getObserv_008())){
				params.add(param.getObserv_008().toUpperCase());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			//USUA??
			params.add(W83bClsConstantes.NULL_STRING);
			//FACTU_037??
			params.add(W83bClsConstantes.NULL_DATE);
			params.add(W83bClsConstantes.NULL_INTEGER);

			if (StringUtils.isNotEmpty(param.getAdmonemp_008())){
				params.add(param.getAdmonemp_008().toUpperCase());

			}else{
					params.add("N");
			}
			if(StringUtils.isNotEmpty(param.getN_cenafec_008())){
				params.add(new Integer(param.getN_cenafec_008()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			//FENVIO??
			params.add(W83bClsConstantes.NULL_DATE);
			//USUENV??

			params.add(W83bClsConstantes.NULL_STRING);
			//ncarpprocelec??
			params.add(W83bClsConstantes.NULL_INTEGER);
			//OID??
			params.add(W83bClsConstantes.NULL_INTEGER);
			//NOP??
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(param.getCodTerritorio());
			//NDF??
			params.add(W83bClsConstantes.NULL_STRING);
		
			
			if (StringUtils.isNotEmpty(param.getC_conv_008())){
				params.add(Integer.valueOf(param.getC_conv_008()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if (StringUtils.isNotEmpty(param.getDirAlternativa())){
				params.add(param.getDirAlternativa());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCodPostalAlternativa())){
				params.add(param.getCodPostalAlternativa());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCodMunicipio_alt())){
				params.add(param.getCodMunicipio_alt());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getIdProvincia_alt())){
				params.add(param.getIdProvincia_alt());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			params.add(new Integer(W83bClsConstantes.tipoPreavisoBandeja));
			W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			
			//dar de alta en el historial
			CallableStatement cs;
		    cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialPreavisos(?,?,?,?,?,?,?)}");
		    cs.setInt(1, Integer.parseInt(param.getNum_preaviso()));
		    cs.setInt(2, Integer.parseInt(param.getAnyoPreaviso()));
		    cs.setString(3, param.getCodTerritorio().toUpperCase());
		    cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
		    cs.setString(5, param.getUsuarioBean().getIdUsuario());
		    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertpreaviso", W83bClsConstantes.CONSTANTE_CASTELLANO));
		    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertpreaviso", W83bClsConstantes.CONSTANTE_EUSKARA));
		    cs.execute();
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "anyadirPreavisos", null);
			throw e;
		}
		
	    
	    return param.getNum_preaviso();
	}
	
	public void anyadirPromotores(W83bPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		//meto los promotores
		
		String[] codsPromotores = null;
		if (StringUtils.isNotEmpty(param.getCodsPromotores())){
			codsPromotores= param.getCodsPromotores().split(",");	
			strSql= new StringBuffer();
			params= new ArrayList();
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preavisos_sindicatos_table);
			strSql.append ("(");
			strSql.append(W83bPreavisosBD.n_preaviso_027);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_preaviso_027);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_027);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_sindi_027);
			strSql.append(")");
			strSql.append(" VALUES (?,?,?,?)");
			params.add(new Integer(param.getNum_preaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(param.getCodTerritorio().toUpperCase());

			for (int i=0;i<codsPromotores.length;i++){
				params.add(codsPromotores[i]);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.remove(params.size()-1);
			}
		}
	}
	
	public void insertarPreavisoOriginal(W83bPreavisosBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();

		strSql = new StringBuffer();
		params = new ArrayList();
		
		try{
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preavisos_originalesTable);
			strSql.append("(");
			strSql.append(W83bPreavisosBD.ano_preaviso_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_preaviso_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_inicio_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_elecc_053);
			strSql.append(",");
			
			strSql.append(W83bPreavisosBD.s_parcial_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.global_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.observ_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usua_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.factu_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.convacu_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.admonemp_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_cenafec_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.fenvio_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usuenv_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ncarprocelec_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.oid8501_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.nop_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ndf_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_conv_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.dir_alt_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.codPos_alt_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.mun_alt_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.prov_alt_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.nif_centro_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.num_centro_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.raz_social_053);
			//29082017-> Ampliacin de campos en preaviso original
			strSql.append(",");
			strSql.append(W83bPreavisosBD.telefono_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.email_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.fax_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.cnae_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.th_ss_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_ss_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ctrl_ss_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_trabaj_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_regis_053);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_regis_053);
			strSql.append(")");
			
			strSql.append(" VALUES (?,?,to_date(?,?),");
			
			if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
				strSql.append("to_date(?,?)");
			}else{
				strSql.append("?");			
			}
			
			strSql.append(",?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
			
			if (StringUtils.isNotEmpty(param.getFechaRegES())){
				strSql.append(",to_date(?,?),?)");
			}else{
				strSql.append(",?,?)");			
			}
			
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(new Integer(param.getNum_preaviso()));
			//TODO obtener el id del centro
			params.add(param.getFecha_inicio());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
				params.add(param.getFecha_eleccion());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);			
			}
			if (StringUtils.isNotEmpty(param.getS_parcial_008())){
				params.add(param.getS_parcial_008().toUpperCase());
			}else{
				params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getGlobal_008())){
				params.add(param.getGlobal_008().toUpperCase());
			}else{
				params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getObserv_008())){
				params.add(param.getObserv_008().toUpperCase());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			//USUA??
			params.add(W83bClsConstantes.NULL_STRING);
			params.add(W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(W83bClsConstantes.CONSTANTE_CASTELLANO));
			params.add(W83bClsConstantes.NULL_INTEGER);
			if (StringUtils.isNotEmpty(param.getAdmonemp_008())){
				params.add(param.getAdmonemp_008().toUpperCase());

			}else{
					params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getN_cenafec_008())){
				params.add(new Integer(param.getN_cenafec_008()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			//FENVIO??
			params.add(W83bClsConstantes.NULL_DATE);
			//USUENV??
			params.add(W83bClsConstantes.NULL_STRING);
			//ncarpprocelec??
			params.add(W83bClsConstantes.NULL_INTEGER);
			//OID??
			params.add(W83bClsConstantes.NULL_INTEGER);
			//NOP??
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(param.getCodTerritorio());
			//NDF??
			params.add(W83bClsConstantes.NULL_STRING);
			if (StringUtils.isNotEmpty(param.getC_conv_008())){
				params.add(Integer.valueOf(param.getC_conv_008()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if (StringUtils.isNotEmpty(param.getDomic_008())){
				params.add(param.getDomic_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCodpos_008())){
				params.add(param.getCodpos_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCodMunicipio())){
				params.add(param.getCodMunicipio());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getProvincia())){
				params.add(param.getProvincia());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCifpreaviso())){
				params.add(param.getCifpreaviso().toUpperCase());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getNumcentropreaviso())){
				params.add(param.getNumcentropreaviso());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getRazonSocialPreaviso())){
				params.add(param.getRazonSocialPreaviso());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			//29082017-> Ampliacin de campos en preaviso original			
			if (StringUtils.isNotEmpty(param.getTelefono_008().trim())){
				params.add(param.getTelefono_008().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getEmail_008().trim())){
				params.add(param.getEmail_008().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getFax_008().trim())){
				params.add(param.getFax_008().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCnae_008().trim())){
				params.add(param.getCnae_008().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getTerritsegsocial().trim())){
				params.add(param.getTerritsegsocial().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getNumsegsocial().trim())){
				params.add(param.getNumsegsocial().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getDigcontsegsocial().trim())){
				params.add(param.getDigcontsegsocial().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getNumtrab().trim())){
				params.add(param.getNumtrab().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getFechaRegES())){
				params.add(param.getFechaRegES().trim());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);			
			}
			if (StringUtils.isNotEmpty(param.getNumRegES())){
				params.add(param.getNumRegES().trim());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			
			//inserto los promotores del preaviso original
			strSql = new StringBuffer();
			params = new ArrayList();
			
			if (StringUtils.isNotEmpty(param.getC_sindi_prom_008())){
				strSql= new StringBuffer();
				params= new ArrayList();
				strSql.append("INSERT INTO ");
				strSql.append(W83bPreavisosBD.preaviso_original_sindicatos_table);
				strSql.append ("(");
				strSql.append(W83bPreavisosBD.n_preaviso_054);
				strSql.append(",");
				strSql.append(W83bPreavisosBD.ano_preaviso_054);
				strSql.append(",");
				strSql.append(W83bPreavisosBD.c_territ_054);
				strSql.append(",");
				strSql.append(W83bPreavisosBD.c_sindi_054);
				strSql.append(")");
				strSql.append(" VALUES (?,?,?,?)");
				params.add(new Integer(param.getNum_preaviso()));
				params.add(new Integer(param.getAnyoPreaviso()));
				params.add(param.getCodTerritorio().toUpperCase());
 
				
				if(param.getC_sindi_prom_008().equals(W83bClsConstantes.VARIOS_SINDICATOS_PROMOTORES) 
						&& StringUtils.isNotEmpty(param.getC_sindi_prom_multi_008())){
					
					int tamanyoSindicatos = param.getC_sindi_prom_multi_008().length();
					
					while (tamanyoSindicatos>0){
						params.add(param.getC_sindi_prom_multi_008().substring(tamanyoSindicatos-3, tamanyoSindicatos));
						tamanyoSindicatos= tamanyoSindicatos-3;
						W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
						params.remove(params.size()-1);
					}
				}else{
					params.add(param.getC_sindi_prom_008());
					W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				}
			}
			
			
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "insertarPreavisoOriginal", null);
			throw e;
		}
		
			
		
	}
	
	public void anyadirHistorialTramitacion(W83bPreavisosBean param,String fase, String tramite,String fechaRegistro)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		try{
			List params = new ArrayList();
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
			
			strSql.append("(");
			strSql.append(W83bPreavisosBD.n_preaviso_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_preaviso_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_tram_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_fase_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_actu_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usua_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usu_mod_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_modif_056);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_tram_056);
			strSql.append(")");
			
			strSql.append(" VALUES (?,?,?,?,?,to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'),?,?,");
			//strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'),");
			strSql.append("?,");
			strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'))");
			
			params.add(new Integer(param.getNum_preaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(param.getCodTerritorio());
			
			params.add(new Integer(tramite));
			params.add(new Integer(fase));
			SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
			params.add(sdf.format(new Date()));
			params.add(param.getUsuarioBean().getIdUsuario());
			//params.add(param.getUsuarioBean().getIdUsuario());
			params.add(W83bClsConstantes.NULL_STRING);
			//params.add(sdf.format(new Date()));
			params.add(W83bClsConstantes.NULL_DATE);

			if(StringUtils.isNotEmpty(fechaRegistro)){
				params.add(fechaRegistro);							
			}else{
				SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
				params.add(hoy.format(new Date()));					
			}
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "anyadirHistorialTramitacion", null);
			throw e;
		}
		
		
		}
	
	public java.lang.String insertarPreavisoModificado(w83b.w83bBeans.W83bPreavisosBean param, String estado, String tipo) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		try{
			StringBuffer strSqlCorrelativo = new StringBuffer(W83bClsConstantes.CUARENTA);
			strSqlCorrelativo.append("SELECT MAX(");
			strSqlCorrelativo.append(W83bPreavisosBD.preaviso_008);
			strSqlCorrelativo.append(") AS ").append(W83bPreavisosBD.preaviso_008);;
			strSqlCorrelativo.append(" FROM ");
			strSqlCorrelativo.append(W83bPreavisosBD.preavPendientesTramVista);
			
			List idPreaviso = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
			int idPreavNext=1;
			
			if (idPreaviso!=null && idPreaviso.size()>0 && idPreaviso.get(0)!=null){
				idPreavNext=Integer.parseInt(idPreaviso.get(0).toString())+1;
			}
			
			//Variables para el caso de promotores multiples
			boolean promotoresMultiples=false;
			StringBuffer listaPromotores = new StringBuffer(W83bClsConstantes.CUARENTA);
			
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preavPendientesTramTabla);
			strSql.append("(");
			strSql.append(W83bPreavisosBD.preaviso_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_regis_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_inicio_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.raz_social_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.cif_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.domic_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.codpos_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.telefono_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.fax_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.email_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.cnae_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_conv_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.s_parcial_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.global_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.admonemp_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_cenafec_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_sindi_prom_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ident_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.observ_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.munic_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_regis_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.lote_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.estado_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_preaviso_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_preaviso_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.prov_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.tipo_008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.identfiscal);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.territsegsocial);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.numsegsocial);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.digcontsegsocial);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.numtrab);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.numcentro008);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_sindi_prom_multi_008);
			strSql.append(")");
			
			strSql.append(" VALUES (?,to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'),to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			
			params.add(new Integer(idPreavNext));//NOPMD
			if (StringUtils.isNotEmpty(param.getFechaRegES())){
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegES(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			if (StringUtils.isNotEmpty(param.getFecha_inicio())){
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecha_inicio(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			if (StringUtils.isNotEmpty(param.getRazonSocialPreaviso())){
				params.add(param.getRazonSocialPreaviso());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCifpreaviso())){
				params.add(param.getCifpreaviso());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCodTerritorio())){
				params.add(param.getCodTerritorio());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getDomic_008())){
				params.add(param.getDomic_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCodpos_008())){
				params.add(param.getCodpos_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getTelefono_008())){
				params.add(param.getTelefono_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getFax_008())){
				params.add(param.getFax_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getEmail_008())){
				params.add(param.getEmail_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getCnae_008())){
				params.add(param.getCnae_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getC_conv_008())){
				params.add(new Integer(param.getC_conv_008()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if (StringUtils.isNotEmpty(param.getS_parcial_008())){
				params.add(param.getS_parcial_008().toUpperCase());
			}else{
				params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getGlobal_008().toUpperCase())){
				params.add(param.getGlobal_008().toUpperCase());
			}else{
				params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getAdmonemp_008())){
				params.add(param.getAdmonemp_008().toUpperCase());

			}else{
					params.add("N");
			}
			if (StringUtils.isNotEmpty(param.getN_cenafec_008())){
				params.add(new Integer(param.getN_cenafec_008()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			
			if (StringUtils.isNotEmpty(param.getCodsPromotores())){
				
				String[] codsPromotores = param.getCodsPromotores().split(",");	

				//Si el tamao es 1, lo aadimos directamente el valor. Si no preparamos la variable de promotores multiples
				if(codsPromotores.length==1){
					params.add(codsPromotores[0]);
				}else{
					promotoresMultiples=true;
					params.add(W83bClsConstantes.VARIOS_SINDICATOS_PROMOTORES);
					
					String codigoPromotor;
					for (int i=0;i<codsPromotores.length;i++){
						codigoPromotor = codsPromotores[i];
						
						//El temao es 3
						while(codigoPromotor.length()<3){
							codigoPromotor = 0+codigoPromotor;
						}
						listaPromotores.append(codigoPromotor);
						
					}
					
				}
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			
			
			
			if (StringUtils.isNotEmpty(param.getIdent_008())){
				params.add(param.getIdent_008());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getObserv_008())){
				params.add(param.getObserv_008().toUpperCase());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getCodMunicipio())){
				params.add(param.getCodMunicipio());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getNumRegES())){
				params.add(param.getNumRegES());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getLote())){
				params.add(new Integer(param.getLote()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			params.add(estado);
			if (StringUtils.isNotEmpty(param.getNum_preaviso())){
				params.add(new Integer(param.getNum_preaviso()));
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getAnyoPreaviso())){
				params.add(new Integer(param.getAnyoPreaviso()));
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getProvincia())){
				params.add(param.getProvincia());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			params.add(tipo);
			if (StringUtils.isNotEmpty(param.getIdentfiscal())){
				params.add(param.getIdentfiscal());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getTerritsegsocial())){
				params.add(param.getTerritsegsocial());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getNumsegsocial())){
				params.add(param.getNumsegsocial());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getDigcontsegsocial())){
				params.add(param.getDigcontsegsocial());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if (StringUtils.isNotEmpty(param.getNumtrab())){
				params.add(new Integer(param.getNumtrab()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			if (StringUtils.isNotEmpty(param.getNumcentropreaviso())){
				params.add(new Integer(param.getNumcentropreaviso()));
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);			
			}
			if (promotoresMultiples){
				params.add(listaPromotores.toString());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			
			W83bDataBase.executeTableMovement(strSql.toString(),params,param.getUsuarioBean());
			
		}catch (Exception e) {
			W83bClsTrazas.trazaError(null, "insertarPreavisoModificado", null);
			throw e;
		}
		
		return "0";
		
	}
	
	public String verSiLoteCompleto(w83b.w83bBeans.W83bPreavisosBean param)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		List listaPreavisos = new ArrayList();
		try{
			strSql.append("SELECT COUNT(");
			strSql.append(W83bPreavisosBD.preaviso_008);
			strSql.append(") FROM ");
			strSql.append(W83bPreavisosBD.preavPendientesTramVista);
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.lote_008);
			strSql.append("=? AND (");
			strSql.append(W83bPreavisosBD.estado_008);
			strSql.append("=?"); 
			strSql.append(" OR ");
			strSql.append(W83bPreavisosBD.estado_008);
			strSql.append("=?)");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.tipo_008);
			strSql.append("=?");
			params.add(param.getLote());
			params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
			params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
			params.add(W83bClsConstantes.TIPOPREAVISOVUELTA);
			listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "verSiLoteCompleto",null);
			throw e;
		}
		
		
		return listaPreavisos.get(0).toString(); 		
	}
	
	public java.util.List buscarPreavisosVueltaTratados(w83b.w83bBeans.W83bPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		List listaPreavisos = new ArrayList();
		
		try{
			strSql.append("SELECT ");
			strSql.append(W83bPreavisosBD.raz_social_008).append(", ");
			strSql.append(W83bPreavisosBD.domic_008).append(", ");
			strSql.append(W83bPreavisosBD.c_territ_008).append(", ");
			strSql.append(W83bPreavisosBD.munic_008).append(", ");
			strSql.append(W83bPreavisosBD.codpos_008).append(", ");
			strSql.append(W83bPreavisosBD.telefono_008).append(", ");
			strSql.append(W83bPreavisosBD.fax_008).append(", ");
			strSql.append(W83bPreavisosBD.email_008).append(", ");
			strSql.append(W83bPreavisosBD.cnae_008).append(", ");
			strSql.append(W83bPreavisosBD.f_inicio_008).append(", ");
			strSql.append(W83bPreavisosBD.c_conv_008).append(", ");
			strSql.append(W83bPreavisosBD.s_parcial_008).append(", ");
			strSql.append(W83bPreavisosBD.global_008).append(", ");
			strSql.append(W83bPreavisosBD.admonemp_008).append(", ");
			strSql.append(W83bPreavisosBD.n_cenafec_008).append(", ");
			strSql.append(W83bPreavisosBD.c_sindi_prom_008).append(", ");
			strSql.append(W83bPreavisosBD.ident_008).append(", ");
			strSql.append(W83bPreavisosBD.observ_008).append(", ");
			strSql.append(W83bPreavisosBD.estado_008).append(", ");
			strSql.append(W83bPreavisosBD.preaviso_008).append(", ");
			strSql.append(W83bPreavisosBD.f_entrada_007).append(", ");
			strSql.append(W83bPreavisosBD.desccnae).append(", ");
			strSql.append(W83bPreavisosBD.cif_008).append(", ");
			strSql.append(W83bPreavisosBD.lote_008).append(", ");
			strSql.append(W83bPreavisosBD.n_regis_008).append(", ");
			strSql.append(W83bPreavisosBD.prov_008).append(", ");
			strSql.append(W83bPreavisosBD.n_preavisos_007).append(", ");
			strSql.append(W83bPreavisosBD.c_sindi_007).append(", ");
			strSql.append(W83bPreavisosBD.correl_007).append(", ");
			strSql.append(W83bPreavisosBD.nombreficheroida).append(", ");
			strSql.append(W83bPreavisosBD.f_creacion_007).append(", ");
			strSql.append(W83bPreavisosBD.identfiscal).append(", ");
			strSql.append(W83bPreavisosBD.territsegsocial).append(", ");
			strSql.append(W83bPreavisosBD.numsegsocial).append(", ");
			strSql.append(W83bPreavisosBD.digcontsegsocial).append(", ");
			strSql.append(W83bPreavisosBD.numtrab).append(", ");
			strSql.append(W83bPreavisosBD.f_regis_008).append(", ");
			strSql.append(W83bPreavisosBD.n_preaviso_008).append(", ");
			strSql.append(W83bPreavisosBD.c_sindi_prom_multi_008).append(", ");
			strSql.append(W83bPreavisosBD.ano_preaviso_008);
			strSql.append(" FROM ").append(W83bPreavisosBD.w83bdetallepreavpendtram);	
			strSql.append(" WHERE ").append(W83bPreavisosBD.lote_008).append("=?");	
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.tipo_008);
			strSql.append("=?");
			params.add(param.getLote());
			params.add(W83bClsConstantes.TIPOPREAVISOVUELTA);
			listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,param.getUsuarioBean(), "DETALLEPREAVPENDTRAM");
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "buscarPreavisosVueltaTratados",null);
			throw e;
		}
		
				
		return listaPreavisos;//NOPMD
	}
	
	public String insertarFicheroVuelta(W83bDocBean param)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		try{
			strSql.append("UPDATE ");
			strSql.append(W83bPreavisosBD.lotesTabla);
			strSql.append(" SET ");
			strSql.append(W83bPreavisosBD.ficherovuelta).append(" = ? ");
			strSql.append(" , ");
			strSql.append(W83bPreavisosBD.nombreficherovuelta).append(" = ? ");
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.lote007);
			strSql.append(" =? ");
			
			params.add(param.getFileData());
			params.add(param.getNombre());
			params.add(new Integer(param.getLotesPreavisosBean().getCodLote()));
			
			W83bDataBase.executeBlobTableMovement(strSql.toString(), params,param.getTamanyo(), param.getUsuarioBean());
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "insertarFicheroVuelta",null);
			throw e;
		}
		return "0";
	}
	
	public W83bLotesPreavisosBean generarNotificaciones(W83bLotesPreavisosBean param)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
			W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)param.getUsuarioBean();
			
			param.setIdioma(usuario.getIdioma());
			
			String territorio = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());
			
			//Obtengo los sindicatos a los que hay que notificar
			strSql.append("SELECT ");
			strSql.append(W83bUsuariosBD.dni);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.territorio);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.nombre);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.apellido1);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.apellido2);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.email);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.fechaAlta);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.fechaBaja);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.telefono);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.codSindi);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.descProvincia);
			strSql.append(", ");
			strSql.append(W83bUsuariosBD.rol);
			strSql.append(" FROM ");
			strSql.append(W83bUsuariosBD.usuariosTable);
			strSql.append(" , ").append(W83bUsuariosBD.provinciasTable);
			strSql.append(" WHERE ");
			strSql.append(W83bUsuariosBD.rol).append("=1");
			strSql.append(" AND ");
			strSql.append(W83bUsuariosBD.territorio).append("=").append(territorio);
			strSql.append(" AND ");
			strSql.append(W83bUsuariosBD.territorio).append("=").append(W83bUsuariosBD.idProvincia);
			strSql.append(" AND ");
			strSql.append(W83bUsuariosBD.fechaBaja).append(" IS NULL ");
			
			W83bClsTrazas.trazaDebug(null," $$$$$$$$$$$$$$$$$$$$$$ strSql::: "+strSql.toString() );
			
			//List listaSindicatos = W83aDataBase.executeSimpleQuery(strSql.toString(),new ArrayList(),null);
			List listaSindicatos = W83bDataBase.executeQuery(strSql.toString(),params,W83bUsuarioBean.class,param.getUsuarioBean(), null);
			W83bClsTrazas.trazaDebug(null,"$$$$$$$$$$$$$$$$$$$$$$ listaSindicatos::: "+listaSindicatos.size() );
			W83bUsuarioBean elSindi = new W83bUsuarioBean();
			
			for(int i=0;i<listaSindicatos.size();i++){
				elSindi = new W83bUsuarioBean();//NOPMD
				elSindi = (W83bUsuarioBean)listaSindicatos.get(i);
				
				strSql = new StringBuffer();//NOPMD
				strSql.append("SELECT ");
				strSql.append(W83bLotesPreavisosBD.siglasSindi19);
				strSql.append(" FROM ");
				strSql.append(W83bLotesPreavisosBD.sindicatosTable);
				strSql.append(" WHERE ");
				strSql.append(W83bLotesPreavisosBD.codSindi19).append("=").append(elSindi.getOrganizacion());
				List lasSiglas = W83bDataBase.executeQuery(strSql.toString(),params,W83bLotesPreavisosBean.class,param.getUsuarioBean(), null);
				W83bClsTrazas.trazaDebug(null,"$$$$$$$$$$$$$$$$$$$$$$ lasSiglas::: "+lasSiglas.size() );
				String descSindi ="";
				if(lasSiglas.size()>0){
					W83bLotesPreavisosBean siglas = (W83bLotesPreavisosBean)lasSiglas.get(0);
					descSindi=siglas.getSiglasSindi();
					W83bClsTrazas.trazaDebug(null,"$$$$$$$$$$$$$$$$$$$$$$ descSindi::: "+descSindi );
				}
				
				elSindi.setDescSindi(descSindi);
				
				
			}
			  
			strSql = new StringBuffer();
			strSql.append("SELECT ");
			strSql.append(W83bLotesPreavisosBD.codLote).append(",");
			strSql.append(W83bLotesPreavisosBD.dni).append(",");
			strSql.append(W83bUsuariosBD.nombre).append(",");
			strSql.append(W83bUsuariosBD.apellido1).append(",");
			strSql.append(W83bUsuariosBD.apellido2).append(",");
			strSql.append(W83bLotesPreavisosBD.territorio).append(",");
			strSql.append(W83bLotesPreavisosBD.correlativo).append(",");
			if("eu".equals(param.getIdioma())){
				strSql.append(W83bLotesPreavisosBD.descSindiEus).append(" AS ").append(W83bLotesPreavisosBD.descSindi).append(",");
			}else{
				strSql.append(W83bLotesPreavisosBD.descSindi).append(" AS ").append(W83bLotesPreavisosBD.descSindi).append(",");
			}		   
			strSql.append(W83bLotesPreavisosBD.ficheroIda).append(",");
			strSql.append(" TO_CHAR( ").append(W83bLotesPreavisosBD.fechaCreacion).append(",?) AS ").append(W83bLotesPreavisosBD.fechaCreacion).append(",");
			strSql.append(" TO_CHAR( ").append(W83bLotesPreavisosBD.fechaEntrada).append(",?) AS ").append(W83bLotesPreavisosBD.fechaEntrada);
			
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			
			strSql.append(" FROM ").append(W83bLotesPreavisosBD.lotesPreavisosTable);
			strSql.append(" , ").append(W83bLotesPreavisosBD.sindicatosTable);
			strSql.append(" , ").append(W83bLotesPreavisosBD.provinciasTable);
			strSql.append(" , ").append(W83bUsuariosBD.usuariosTable);
			strSql.append(" WHERE ").append(W83bLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83bLotesPreavisosBD.codTerrit);
			strSql.append(" = ").append(W83bLotesPreavisosBD.provinciasTable).append(".").append(W83bLotesPreavisosBD.id);
			strSql.append(" AND ").append(W83bLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83bLotesPreavisosBD.codSindi07);
			strSql.append(" = ").append(W83bLotesPreavisosBD.sindicatosTable).append(".").append(W83bLotesPreavisosBD.codSindi19);
			strSql.append(" AND ").append(W83bLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83bLotesPreavisosBD.dni);
			strSql.append(" = ").append(W83bUsuariosBD.usuariosTable).append(".").append(W83bUsuariosBD.dni);
			strSql.append(" AND ").append(W83bLotesPreavisosBD.codLote).append(" = ").append(param.getCodLote());
			

			W83bClsTrazas.trazaDebug(null, "SQL:"+ strSql.toString());
			W83bClsTrazas.trazaDebug(null, "LOTE: " + param.getCodLote());
			
			List listaLotes = W83bDataBase.executeQuery(strSql.toString(),params,W83bLotesPreavisosBean.class,param.getUsuarioBean(), null);
		
			W83bLotesPreavisosBean param2 = (W83bLotesPreavisosBean)listaLotes.get(0);	
			param.setDescSindicato(param2.getDescSindicato());
			param.setFechaCreacion(param2.getFechaCreacion());
			param.setFechaEntrada(param2.getFechaEntrada());
			param.setTerritorio(param2.getTerritorio());
			

			W83bInformacionProcedimiento info = new W83bInformacionProcedimiento(param.getUsuarioBean().getSessionTokenXLNets(), W83bProperties.getProperty("w83b","catalogo.procedureId"));
			
			W83bNotificacionesBean informacionNotificacion= new W83bNotificacionesBean(usuario.getDniUsuario(), usuario.getNombreUsuario(), "", param.getNombreFichero(), param.getCodLote()+"", param.getUsuarioBean().getSessionTokenXLNets(), territorio);
			
			//Aadimos los datos del emisor
			informacionNotificacion.setDniUsuarioEmisor(param2.getDniEmisorLote());
			informacionNotificacion.setSindicatoUsuarioEmisor(param2.getDescSindicato());
			informacionNotificacion.setNombreUsuarioEmisor(param2.getNombreEmisorLote());
			informacionNotificacion.setApellido1UsuarioEmisor(param2.getApellido1EmisorLote());
			informacionNotificacion.setApellido2UsuarioEmisor(param2.getApellido2EmisorLote());
			
			W83bNotificacionThread tareaNotificar=new W83bNotificacionThread((ArrayList)listaSindicatos,info,param.getSolicitudPreaviso(),informacionNotificacion,W83bClsConstantes.SALIDA, param.getNombreFichero(), param.getDocumentoImportadoOriginal(),usuario.getIdioma());
	        tareaNotificar.start();
			
	        
	        param.setDescTerritorio(territorio);
	        return param ;	
		
	}
	
	public void modificarCampoTratado(w83b.w83bBeans.W83bLotesPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		try{
			strSql.append("UPDATE ");
			strSql.append(W83bPreavisosBD.lotesTabla);
			strSql.append(" SET ");
			strSql.append(W83bLotesPreavisosBD.tratado).append(" = ? ");
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.lote007);
			strSql.append(" =? ");
			
			params.add(String.valueOf(W83bClsConstantes.UNO));
			params.add(new Integer(param.getCodLote()));
			
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "modificarCampoTratado",null);
			throw e;
		}
		
		
	}
	
}